function[CH,dCH]=Homogenization_3D(nelx,nely,nelz,lx,ly,lz,vxPhys,E,NU,keLambda,keMu,feLambda,feMu,nele,edofMat,ndof)
[x_lambda,x_mu,dlambda_x,dmu_x]=ENU_dENU(E,NU,vxPhys);
sK=keLambda(:)*x_lambda(:)'+keMu(:)*x_mu(:)';
sF=feLambda(:)*x_lambda(:)'+feMu(:)*x_mu(:)';
%% Begin
iK=kron(edofMat,ones(24,1))';
jK=kron(edofMat,ones(1,24))';
K=sparse(iK(:),jK(:),sK(:),ndof,ndof); K = (K+K')/2;
iF=repmat(edofMat',6,1);
jF=[ones(24,nele); 2*ones(24,nele); 3*ones(24,nele);4*ones(24,nele);5*ones(24,nele);6*ones(24,nele)];
F=sparse(iF(:), jF(:), sF(:), ndof, 6);
%% Solve with pcg
tolit=1e-8; maxit=8000;
fixeddof=[1:3];
freedofs=setdiff(1:ndof,fixeddof);
M=diag(diag(K(freedofs,freedofs)));
[chi(freedofs,1),flag]=pcg(K(freedofs,freedofs),F(freedofs,1),tolit,maxit,M);
[chi(freedofs,2),flag]=pcg(K(freedofs,freedofs),F(freedofs,2),tolit,maxit,M);
[chi(freedofs,3),flag]=pcg(K(freedofs,freedofs),F(freedofs,3),tolit,maxit,M);
[chi(freedofs,4),flag]=pcg(K(freedofs,freedofs),F(freedofs,4),tolit,maxit,M);
[chi(freedofs,5),flag]=pcg(K(freedofs,freedofs),F(freedofs,5),tolit,maxit,M);
[chi(freedofs,6),flag]=pcg(K(freedofs,freedofs),F(freedofs,6),tolit,maxit,M);
%% HOMOGENIZATION
%% The displacement vectors corresponding to the unit strain cases
chi0=zeros(nele, 24, 6);
%The element displacements for the three 6 strains
chi0_e=zeros(24, 6);
KE=keLambda+keMu;
FE=feLambda+feMu;
chi0_e([1:8 15:end],:)=KE([1:8 15:end],[1:8 15:end])\FE([1:8 15:end],:);  
chi0(:,:,1)=kron(chi0_e(:,1)', ones(nele,1));
chi0(:,:,2)=kron(chi0_e(:,2)', ones(nele,1));
chi0(:,:,3)=kron(chi0_e(:,3)', ones(nele,1));
chi0(:,:,4)=kron(chi0_e(:,4)', ones(nele,1));
chi0(:,:,5)=kron(chi0_e(:,5)', ones(nele,1));
chi0(:,:,6)=kron(chi0_e(:,6)', ones(nele,1));
CH=zeros(6);  dCH=cell(6,6);
cellVolume=lx*ly*lz;
for i=1:6
    for j=1:6
        sumkeLambda=((chi0(:,:,i) - chi(edofMat+(i-1)*ndof))*keLambda).*...
        (chi0(:,:,j) - chi(edofMat+(j-1)*ndof));
        sumkeMu=((chi0(:,:,i) - chi(edofMat+(i-1)*ndof))*keMu).*...
        (chi0(:,:,j) - chi(edofMat+(j-1)*ndof));
    
        sumLambda=x_lambda.*reshape(sum(sumkeLambda,2), nely, nelx,nelz);
        sumMu=x_mu.*reshape(sum(sumkeMu,2), nely, nelx,nelz);
        sumK=sumLambda+sumMu;
        
        dsumLambda=dlambda_x.*reshape(sum(sumkeLambda,2), nely, nelx,nelz);
        dsumMu=dmu_x.*reshape(sum(sumkeMu,2), nely, nelx,nelz);
        dsumK=dsumLambda+dsumMu; 
        
        CH(i,j)=1/cellVolume*sum(sum(sum(sumK)));
        dCH{i,j}=1/cellVolume*dsumK;                                                
    end
end
[CH,dCH]=symm(CH,dCH);
